/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoODBC - picoSQL ODBC driver

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifdef WIN32
# include <windows.h>
# endif
# include <stdio.h>
# include <string.h>
# include <odbcinst.h>
# include "envirini.h"
static char rcsid[] = "$Id: envirini.cpp 4.0 1998/10/27 16:20:27 picoSoft Exp $";
static char rcsidh[] = envirini_h;

EnvirIni::EnvirIni()
{
   Init();
}
# ifdef WIN32
EnvirIni::EnvirIni(const char *p, HKEY hHome)
{
   Init(); 
}  
# endif
EnvirIni::~EnvirIni ()
{
}

void
EnvirIni::Init()
{ 
   rc = 0;
}

long
EnvirIni::Read(const char *dsn, const char *key,
               char *value, const int lenValue, 
               const char *fileini)
{
   unsigned long Return = 0;

   Return = SQLGetPrivateProfileString(dsn, key, "", value, lenValue, fileini);
   if (Return == (unsigned long)(lenValue - 1))
      rc = ENV_MORE_DATA; 
   else if (Return == 0)
      rc = 2; 
   return Return;
}

long
EnvirIni::GetLastRetCode()
{
   return rc;
}
