/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picocpp - basic objects library for picoSQL 

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef list_h
# define list_h "$Id: plist.h 1.4 96/07/01 09:15:09 picoSoft Exp $"
# include "plistitm.h"

class PIterator;

class PList : public PObject {
friend class PIterator;
   PCLASS(PList, PObject)
   PListItem * root;
   PListItem * current;
   long itemNum;
public:
   PList ();
   PList (PList &);
   ~PList ();
   void AddItem (PObject *);
   int InsertItem (PObject *);
   virtual int CollSeq (PObject *New, PObject *Cfrt) {return -1;}
   PObject * GetFirst ();
   PObject * GetLast ();
   PObject * GetCurrent ();
   PObject * SetCurrent (PObject *);
   PObject * GetNext ();
   PObject * GetPrevious ();
   PObject * GetAt (int indx);
   PObject * DeleteCurrent ();
   PList & operator=(PList &);
   long GetItemNum () { return itemNum; }
};

# define PLIST(a) \
class a##List : public PList \
{ \
public: \
   void InsertItem (a * s) { PList::InsertItem ((PObject *) s); } \
   void AddItem (a * s) { PList::AddItem ((PObject *) s); } \
   a * GetFirst () { return (a *) PList::GetFirst ();} \
   a * GetLast ()  { return (a *) PList::GetLast ();} \
   a * GetCurrent ()  { return (a *) PList::GetCurrent ();} \
   a * SetCurrent (a * s)  { return (a *) PList::SetCurrent ((PObject *) s);} \
   a * GetNext ()  { return (a *) PList::GetNext ();} \
   a * GetPrevious ()  { return (a *) PList::GetPrevious ();} \
   a * GetAt (int i)  { return (a *) PList::GetAt (i);} \
   a * DeleteCurrent () {return (a *) PList::DeleteCurrent ();} \
}

# define PCOPYLIST(a) \
class a##CopyList : public PList \
{ \
public: \
   void AddItem (a &s) { a * cpy = new a(s); PList::AddItem ((PObject *) cpy); } \
   a * GetFirst () { return (a *) PList::GetFirst ();} \
   a * GetLast ()  { return (a *) PList::GetLast ();} \
   a * GetCurrent ()  { return (a *) PList::GetCurrent ();} \
   a * GetNext ()  { return (a *) PList::GetNext ();} \
   a * GetPrevious ()  { return (a *) PList::GetPrevious ();} \
   a * GetAt (int i)  { return (a *) PList::GetAt (i);} \
   a * DeleteCurrent () {a * cpy = GetCurrent(); \
                         if (cpy) \
                            delete cpy; \
                         return (a *) PList::DeleteCurrent ();} \
   ~a##CopyList() { GetFirst(); while (DeleteCurrent()); } \
}


# endif
