/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "giop.h"

static char *rcsid = "$Id: giop.c,v 1.1 1999/06/03 11:41:36 picoSoft Exp $";
static char *rcsidh = giop_h;

CORBA_ULong
GiopHeader (Message *msg, MsgType t)
{
   CORBA_Octet *header = msg->logicBuffer + Message_skipBytes (msg, 8);

   header[0] = 'G';
   header[1] = 'I';
   header[2] = 'O';
   header[3] = 'P';

   header[4] = 1; /* major version */
   header[5] = 0; /* minor version */
   header[6] = msg->myByteOrder;
   header[7] = (char) t;

   Message_skipBytes (msg, sizeof (CORBA_ULong));
   return 8;
}

CORBA_Boolean
GiopCheckHeader (MessageHeader *he, Message *msg)
{
   char *header = msg->logicBuffer + Message_skipBytes (msg, 8);
   if (header[0] != 'G' ||
       header[1] != 'I' ||
       header[2] != 'O' ||
       header[3] != 'P' ||
       header[4] > 1    || /* major version */
       header[5] > 0)      /* minor version */
      return CORBA_False;
   he->giopVersion.major = header[4];
   he->giopVersion.minor = header[5];
   he->byteOrder = header[6] ? CORBA_True : CORBA_False;
   he->type = (MsgType) header[7];
   msg->msgByteOrder = he->byteOrder;
   Message_getULong (msg, &he->size);
   return CORBA_True;
}
